/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.ccfw.pa.ar;

import com.ibm.hsc.ccfw.pa.event.SurveillanceNotificationDataEvent;
import com.ibm.hwmca.base.pa.ar.DistributedDataEventAnalysisRoutine;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEvent;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEventListener;
import com.ibm.hwmca.fw.pa.incident.IncidentPool;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.pa.event.GlobalSurveillanceDataEvent;
import com.ibm.hwmca.p.pa.event.PelDataEvent;
import com.ibm.hwmca.p.pa.event.SaelDataEvent;
import com.ibm.hwmca.p.pa.problem.PIProblem;
import com.ibm.hwmca.xfw.pa.domain.DistributedAnalysisDomain;
import com.ibm.hwmca.xfw.pa.event.CommonDataEvent;
import com.ibm.hwmca.xfw.pa.event.DistributedDataEvent;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.pa.system.RemotePartitionSystem;
import java.util.ArrayList;

public class InitialSurveillanceDomainAnalysisRoutine
extends DistributedDataEventAnalysisRoutine
implements ProblemAnalysisEventListener {
    private static final String TRACE_MASKT = "PPAISART";
    private static final String TRACE_MASKF = "PPAISARF";
    private static final String TRACE_MASKD = "PPAISARD";
    private static final String OS_400 = "OS400";
    private boolean trumped = false;
    private long timeInterval = 0L;

    public InitialSurveillanceDomainAnalysisRoutine() {
        Trace.trace((String)TRACE_MASKD, (Object)"<-> ctor");
    }

    public void analyze(ProblemAnalysisEvent problemAnalysisEvent) {
        Trace.trace((String)TRACE_MASKD, (Object)"--> analyze()");
        DistributedDataEvent distributedDataEvent = (DistributedDataEvent)problemAnalysisEvent;
        DistributedAnalysisDomain distributedAnalysisDomain = (DistributedAnalysisDomain)this.getEventDomain((CommonDataEvent)distributedDataEvent);
        if (distributedAnalysisDomain == null) {
            Log log = new Log(-86, 70, 0, "PA EVT DSCRD", null, null, null, null);
            String string = "could not find domain for event: " + distributedDataEvent.getDomainId().getDID();
            log.add((byte)3, (Object)string);
            log.log();
            Trace.trace((String)TRACE_MASKT, (Object)"<-- analyze(): cannot obtain domain for event");
            return;
        }
        if (distributedDataEvent instanceof SurveillanceNotificationDataEvent || distributedDataEvent instanceof PelDataEvent && ((PelDataEvent)distributedDataEvent).isSurveillanceError() || distributedDataEvent instanceof SaelDataEvent && ((SaelDataEvent)distributedDataEvent).isSurveillanceError()) {
            Trace.trace((String)TRACE_MASKD, (Object)"Surveillance need to look for pools with the same system");
            Trace.trace((String)TRACE_MASKD, (Object)"Discard this Surveillance Error if those exist");
            if (this.ifTrumped(distributedDataEvent, this.timeInterval)) {
                Log log = new Log(-86, 70, 0, "PA EVT DSCRD", null, null, null, null);
                String string = "trumped event problems for this even exist in other pools: " + distributedDataEvent.getDomainId().getDID();
                log.add((byte)3, (Object)string);
                log.log();
                Trace.trace((String)TRACE_MASKF, (Object)"<-- analyze(): Trumped problem event exists in other pools for the system in this event");
                return;
            }
            if (distributedDataEvent instanceof SurveillanceNotificationDataEvent && (((SurveillanceNotificationDataEvent)distributedDataEvent).get_endPointB() == null || ((SurveillanceNotificationDataEvent)distributedDataEvent).get_endPointB() != null && ((SurveillanceNotificationDataEvent)distributedDataEvent).get_endPointB().getMTMS().equals("-/"))) {
                Log log = new Log(-86, 70, 0, "PA EVT DSCRD", null, null, null, null);
                String string = "no failing system in SurveillanceNotifcationDataEvent: ";
                log.add((byte)3, (Object)string);
                log.log();
                Trace.trace((String)TRACE_MASKT, (Object)"<-- InitialSurveillanceDomainAnalysisRoutine.analyze(): no failingSystem in event");
                return;
            }
            if (distributedDataEvent.getRefcode() == null || distributedDataEvent.getRefcode().length() == 0) {
                Log log = new Log(-86, 70, 0, "PA EVT DSCRD", null, null, null, null);
                String string = "Surveillance event with null or empty refcode usually was a positive message rather than failure: " + distributedDataEvent.getDomainId().getDID();
                log.add((byte)3, (Object)string);
                log.log();
                Trace.trace((String)TRACE_MASKF, (Object)"<-- analyze(): Surveillance event with null or empty refcode usually was a positive message rather than failure");
                return;
            }
            this.processEvent(distributedDataEvent);
            if (this.anIncident == null) {
                Log log = new Log(-86, 70, 0, "PA EVT DSCRD", null, null, null, null);
                String string = "couldn't create incident";
                log.add((byte)3, (Object)string);
                log.log();
                Trace.trace((String)TRACE_MASKT, (Object)"<-- analyze(): couldn't create incident");
                return;
            }
            PIProblem pIProblem = (PIProblem)this.anIncident.getProblem();
            if (pIProblem == null) {
                Log log = new Log(-86, 70, 0, "PA EVT DSCRD", null, null, null, null);
                String string = "couldn't create problem";
                log.add((byte)3, (Object)string);
                log.log();
                Trace.trace((String)TRACE_MASKT, (Object)"<-- analyze(): couldn't create problem");
                return;
            }
            String string = pIProblem.getRefcode();
            if (string.length() < 8 || string.indexOf("-") != -1) {
                pIProblem.setSymptomString("9100 SRN" + string);
            } else {
                pIProblem.setSymptomString("9100 SRC" + string);
            }
            pIProblem.setFirstReportedTimestamp(distributedDataEvent.getFirstReportedTime());
            pIProblem.setLastReportedTimestamp(distributedDataEvent.getFirstReportedTime());
            pIProblem.setFailingSystem(distributedDataEvent.getFailingEnclosureSystem());
            pIProblem.setServiceableEventText(distributedDataEvent.getSvcEventText());
            pIProblem.setEventSeverity(distributedDataEvent.getEventSeverity());
            pIProblem.addAssociatedCECSystem(distributedDataEvent.getAssociatedSystemList());
            LocalizableText localizableText = distributedDataEvent.getNotificationType();
            if (localizableText != null) {
                pIProblem.setNotificationType(localizableText);
                pIProblem.setNotifyCustomer(localizableText.toString().equals(new LocalizableText("Service Action (customer notification) Required").toString()) || localizableText.toString().equals(new LocalizableText("Call Home Required").toString()));
                pIProblem.setCallHome(localizableText.toString().equals(new LocalizableText("Call Home Required").toString()));
            } else {
                pIProblem.setNotificationType(new LocalizableText("Service Action (customer notification) Required"));
                pIProblem.setCallHome(false);
                pIProblem.setNotifyCustomer(true);
            }
            pIProblem.setServiceableEventCreationTimestamp(System.currentTimeMillis());
            pIProblem.setPlatformLogID(distributedDataEvent.getPlatformLogID());
            pIProblem.setSubsystemID(distributedDataEvent.getSubsystemID());
            pIProblem.setHMCLocale(distributedDataEvent.getHMCLocales());
            pIProblem.setNlsMessages(distributedDataEvent.getNLSMessages());
            pIProblem.addParts(distributedDataEvent.getFruList());
            pIProblem.setServiceableEventText(distributedDataEvent.getSvcEventText());
            if (distributedDataEvent instanceof PelDataEvent || distributedDataEvent instanceof SaelDataEvent) {
                pIProblem.setRefcode(this.subsystemIdToRefcode(distributedDataEvent.getSubsystemID()));
                if (problemAnalysisEvent instanceof SaelDataEvent) {
                    SaelDataEvent saelDataEvent = (SaelDataEvent)problemAnalysisEvent;
                    pIProblem.setPartitionID(saelDataEvent.getPartitionID());
                    pIProblem.setPartitionName(saelDataEvent.getPartitionName());
                    pIProblem.setPartitionHostName(saelDataEvent.getPartitionHostName());
                    pIProblem.setPartitionOSType(saelDataEvent.getPartitionOSType());
                    pIProblem.setClusterSystem(saelDataEvent.getClusterSystem());
                    pIProblem.setSwitchNetworkID(saelDataEvent.getHPSNetworkID());
                    pIProblem.setErrorLogLabelID(saelDataEvent.getErrorLogLabel());
                    pIProblem.setEED(saelDataEvent.getEED());
                    pIProblem.setSequenceNumber(saelDataEvent.getSeqNum());
                    if (saelDataEvent.getPartitionOSType() != null && saelDataEvent.getPartitionOSType().equals(OS_400)) {
                        Trace.trace((String)TRACE_MASKD, (Object)("OS_400 sael set systemLogId with errorLogLabel " + saelDataEvent.getErrorLogLabel()));
                        pIProblem.setSystemLogID(saelDataEvent.getErrorLogLabel());
                    } else {
                        Trace.trace((String)TRACE_MASKD, (Object)("non OS/400 sael set systemLogId with getSystemLogId " + saelDataEvent.getSystemLogId()));
                        pIProblem.setSystemLogID(saelDataEvent.getSystemLogId());
                    }
                    pIProblem.setSymptomString(saelDataEvent.getSymptomString());
                    pIProblem.setFirstReportedTimestamp(saelDataEvent.timeStringToLong(saelDataEvent.getSaelFirstReportedTime()));
                    pIProblem.setLastReportedTimestamp(saelDataEvent.timeStringToLong(saelDataEvent.getLastSubsystemReportedTime()));
                    pIProblem.setCallHome(saelDataEvent.getCalledHome() != 1L);
                }
            } else if (distributedDataEvent instanceof SurveillanceNotificationDataEvent) {
                pIProblem.setRefcode(distributedDataEvent.getRefcode());
                if (((SurveillanceNotificationDataEvent)distributedDataEvent).getEndPointA() == null) {
                    Log log = new Log(-86, 70, 0, "PA EVT DSCRD", null, null, null, null);
                    String string2 = "SurveillanceNotificationEvent without endPointA: " + distributedDataEvent.getDomainId().getDID();
                    log.add((byte)3, (Object)string2);
                    log.log();
                    Trace.trace((String)TRACE_MASKT, (Object)"<-- analyze(): Surveillance error discarded - SurveillanceNotificationEvent without endPointA");
                    return;
                }
                pIProblem.setReportingRemoteMachineSystem(((SurveillanceNotificationDataEvent)distributedDataEvent).getEndPointA());
                if (((SurveillanceNotificationDataEvent)distributedDataEvent).get_timeStamp() == 0L) {
                    pIProblem.setFirstReportedTimestamp(System.currentTimeMillis());
                    pIProblem.setLastReportedTimestamp(System.currentTimeMillis());
                } else {
                    pIProblem.setFirstReportedTimestamp(((SurveillanceNotificationDataEvent)distributedDataEvent).get_timeStamp());
                    pIProblem.setLastReportedTimestamp(((SurveillanceNotificationDataEvent)distributedDataEvent).get_timeStamp());
                }
                if (((SurveillanceNotificationDataEvent)distributedDataEvent).getEndPointB() != null) {
                    pIProblem.setFailingSystem(((SurveillanceNotificationDataEvent)distributedDataEvent).getEndPointB());
                    Trace.trace((String)TRACE_MASKD, (Object)("surveillanceEvent.getRefcode=" + ((SurveillanceNotificationDataEvent)distributedDataEvent).getRefcode() + " failureReason =" + ((SurveillanceNotificationDataEvent)distributedDataEvent).getFailureReason()));
                    if (((SurveillanceNotificationDataEvent)distributedDataEvent).getEndPointB() instanceof RemotePartitionSystem) {
                        Trace.trace((String)TRACE_MASKD, (Object)"failing system endPointB instanceof RemotePartitionSystem");
                    } else {
                        Trace.trace((String)TRACE_MASKD, (Object)"failing system endPointB not instanceof RemotePartitionSystem");
                    }
                    Trace.trace((String)TRACE_MASKD, (Object)("failing system endPointB.getMOSystemName()" + ((SurveillanceNotificationDataEvent)distributedDataEvent).getEndPointB().getMOSystemName() + "class of " + ((SurveillanceNotificationDataEvent)distributedDataEvent).getEndPointB().getClass().getName()));
                } else {
                    pIProblem.setFailingSystem(((SurveillanceNotificationDataEvent)distributedDataEvent).getEndPointA());
                    Trace.trace((String)TRACE_MASKD, (Object)("failing system endPointA.getMOSystemName()" + ((SurveillanceNotificationDataEvent)distributedDataEvent).getEndPointA().getMOSystemName() + "class of " + ((SurveillanceNotificationDataEvent)distributedDataEvent).getEndPointA().getClass().getName()));
                }
            }
        } else if (distributedDataEvent instanceof GlobalSurveillanceDataEvent) {
            this.anIncident.setProblem((CommonProblem)distributedDataEvent.getData());
        } else {
            String string = new String();
            Trace.trace((String)TRACE_MASKD, (Object)"<-- analyze(): Non-Surveillance error discarded");
            return;
        }
        int n = distributedAnalysisDomain.getInitialWait();
        Trace.trace((String)TRACE_MASKD, (Object)("time to wait = " + n));
        this.reportIncident((CommonDataEvent)distributedDataEvent, this.anIncident, distributedAnalysisDomain.getInitialTimeoutEvent((Object)this), distributedAnalysisDomain.getInitialWait());
        Trace.trace((String)TRACE_MASKD, (Object)"<-- analyze()");
    }

    private String subsystemIdToRefcode(int n) {
        String string = "";
        if (n == 122) {
            string = "B3030011";
        } else if (n == 123) {
            string = "B3030012";
        } else if (n == 124) {
            string = "B3030001";
        } else if (n == 125) {
            string = "B3030002";
        } else if (n != 126 && n == 127) {
            string = "B3030008";
        }
        return string;
    }

    private boolean ifTrumped(DistributedDataEvent distributedDataEvent, long l) {
        boolean bl = false;
        ArrayList arrayList = this.getPools(distributedDataEvent.getSystem().getMTMS(), new Long(l).toString());
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                IncidentPool incidentPool = (IncidentPool)arrayList.get(i);
                Trace.trace((String)TRACE_MASKD, (Object)("pool from all pools = " + incidentPool.getPoolId() + " size = " + incidentPool.size()));
                if (incidentPool.size() <= 0) continue;
                return true;
            }
        }
        return bl;
    }
}

